/*
 DHT 11 conectat la gnd, +3.3V, GPIO 16
 Hall intern, 
 Oled conectat SDA la GPIO21 SCK la GPIO22
 genereaza Server AP cu 
 IP 192.168.4.1
 receptionat cu Rx ESP32 Hall Temp ST7735 lib TFT_eSPI
*/

#include <WiFi.h>
#include "DHT.h"
#define DHTTYPE DHT11   // DHT 11

const char* WIFI_NAME= "ESP32-HotSpot"; 
const char* WIFI_PASSWORD = "12345678"; 

WiFiServer server(80);

const int DHTPin = 16;//DHT la pin D16
DHT dht(DHTPin, DHTTYPE);

char linebuf[80];
int charcount=0;
#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>

#define OLED_ADDR   0x3C

Adafruit_SSD1306 display(-1);

void setup() {
  dht.begin();
  Serial.begin(115200);

  WiFi.softAP(WIFI_NAME, WIFI_PASSWORD);
  IPAddress IP = WiFi.softAPIP();

  Serial.print("AP IP address: ");
  Serial.println(IP);

  server.begin();
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("oled DHT11 ESP32 Hot Spot IP=");
  display.print(IP);
  display.display();
  delay(5000);
  }

  void loop() {
  float val = hallRead();
  float temp = dht.readTemperature();
  float humi = dht.readHumidity();
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);//trebuie
  display.setCursor(0,0);
  display.print("T=");
  display.println(temp);
  display.print("B=");
  display.println(val);
  display.print("H=");
  display.println(humi);
  
  display.display();
  delay(1000);
  // listen for incoming clients
  WiFiClient client = server.available();
  if (client) {
    Serial.println("New client");
    memset(linebuf,0,sizeof(linebuf));
    charcount=0;
    boolean currentLineIsBlank = true;
    while (client.connected()) {
      if (client.available()) {
        char c = client.read();
        Serial.write(c);   
          // send a standard http response header 
          client.println("HTTP/1.1 200 OK");
          client.println("Content-Type: text/html");
          client.println("Connection: close");  // the connection will be closed after completion of the response
          client.println();
           
          client.print("T=");
          client.println(temp);
          client.print("H=");
          client.println(humi);
          client.print("B=");
          client.println(val);   
          break;
        }
        }
    delay(1);
    // close the connection:
    client.stop();
    Serial.println("client disconnected");
    //delay(1000);
    }
    }
